﻿using System;
using System.Data.SQLite;
using DataAccess.DataTables;
using DataAccess.DataRows;

namespace DataAccess.TableAdapters
{
    public class ConfigurationTableAdapter
    {
        public ConfigurationDataTable FillByAll()
        {
            ConfigurationDataTable dt = new ConfigurationDataTable();
            SQLiteConnection conn = ConnectionProxy.GetConnection();

            try
            {
                conn.Open();
                SQLiteCommand selectAll = new SQLiteCommand(conn);
                selectAll.CommandText = "SELECT * FROM CONFIGURATION";

                SQLiteDataAdapter da = new SQLiteDataAdapter(selectAll);
                da.Fill(dt);
            }
            catch (SQLiteException ex)
            {
                dt = null;
            }
            finally
            {
                conn.Close();
            }

            return dt;
        }

        public ConfigurationDataRow FillByID(int id)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            ConfigurationDataTable dt = new ConfigurationDataTable();
            bool success = true;
            try
            {
                conn.Open();
                SQLiteCommand selectById = new SQLiteCommand(conn);
                selectById.CommandText = "SELECT * FROM CONFIGURATION WHERE ID = " + id;

                SQLiteDataAdapter da = new SQLiteDataAdapter(selectById);
                da.Fill(dt);
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            if (!success)
            {
                return null;
            }

            return dt[0];
        }

        public ConfigurationDataRow FillByKey(string key)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            ConfigurationDataTable dt = new ConfigurationDataTable();
            bool success = true;

            try
            {
                conn.Open();
                SQLiteCommand selectById = new SQLiteCommand(conn);
                selectById.CommandText = "SELECT * FROM CONFIGURATION WHERE KEY = '" + key + "'";

                SQLiteDataAdapter da = new SQLiteDataAdapter(selectById);
                da.Fill(dt);
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            if (!success)
            {
                return null;
            }

            return dt[0];
        }

        public bool InsertConfiguration(string key, string value)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            bool success = true;

            try
            {
                conn.Open();
                SQLiteCommand insert = new SQLiteCommand(conn);
                insert.CommandText = "INSERT INTO CONFIGURATION (KEY, VALUE) VALUES('" + key + "','" + value + "')";

                if (insert.ExecuteNonQuery() < 1)
                {
                    throw new Exception("Error inserting in to CONFIGURATION table.");
                }
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            return success;
        }

        public bool UpdateConfigurationById(int id, string key, string value)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            bool success = true;

            try
            {
                conn.Open();
                SQLiteCommand insert = new SQLiteCommand(conn);
                insert.CommandText = "UPDATE CONFIGURATION SET KEY = '" + key + "', VALUE = '" + value + "' WHERE ID = " + id;


                if (insert.ExecuteNonQuery() < 1)
                {
                    throw new Exception("Error updating in to CONFIGURATION table.");
                }
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            return success;
        }

        public bool UpdateConfigurationByKey(string key, string value)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            bool success = true;

            try
            {
                conn.Open();
                SQLiteCommand insert = new SQLiteCommand(conn);
                insert.CommandText = "UPDATE CONFIGURATION SET VALUE = '" + value + "' WHERE KEY = '" + key + "'";

                if (insert.ExecuteNonQuery() < 1)
                {
                    throw new Exception("Error updating in to CONFIGURATION table.");
                }
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            return success;
        }

        public bool DeleteConfigurationById(int id)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            bool success = true;

            try
            {
                conn.Open();
                SQLiteCommand insert = new SQLiteCommand(conn);
                insert.CommandText = "DELETE FROM CONFIGURATION WHERE ID = " + id;

                if (insert.ExecuteNonQuery() < 1)
                {
                    throw new Exception("Error deleting from CONFIGURATION table.");
                }
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            return success;
        }

        public bool DeleteConfigurationByKey(string key)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            bool success = true;

            try
            {
                conn.Open();
                SQLiteCommand insert = new SQLiteCommand(conn);
                insert.CommandText = "DELETE FROM CONFIGURATION WHERE KEY = '" + key + "'";

                if (insert.ExecuteNonQuery() < 1)
                {
                    throw new Exception("Error deleting from CONFIGURATION table.");
                }
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            return success;
        }
    }
}
